/**
 * Ampel mit Schaltflchen 
 * 
 * Schalten: Schaltet weiter zur nchsten Ampelphase
 * Reset:    Schaltet die Ampel in den Anfangszustand (rot). 
 * 
 * 2008 - 05 - 15
 */

color Hintergrundfarbe = #999999;
BUTTON b_Schalten;
BUTTON b_Reset;
color rot   = #FF0000;
color gelb  = #FFFF00;
color gruen = #00FF00;
AMPEL A;

void setup()
{
  size(400, 400);
  smooth(); 
  background(Hintergrundfarbe);
  b_Schalten = new BUTTON(66,  360, 100, 30, "Schalten");
  b_Reset    = new BUTTON(233, 360, 100, 30, "Reset"   );
  A = new AMPEL(200);
}

void draw() { }

void mouseReleased()
{
  if ((mouseButton == LEFT) && b_Schalten.angeklickt() )
     { A.Schalten();  b_Schalten.losgelassen();        }
  if ((mouseButton == LEFT) && b_Reset.angeklickt()    )
     { A.Reset();     b_Reset.losgelassen();           }
}

void mousePressed()
{
  if ((mouseButton == LEFT) && b_Schalten.angeklickt() ) 
     { b_Schalten.gedrueckt(); }
  if ((mouseButton == LEFT) && b_Reset.angeklickt()    )
     { b_Reset.gedrueckt();  }
}

class BUTTON
{
  int x, y, b, h;
  String s;
  PFont font;
  color Buttonfarbe  = #CCCCCC;
  color Schriftfarbe = #000000;
  color Randfarbe_d  = #000000;
  color Randfarbe_h  = #FFFFFF;
  
  BUTTON(int x_neu, int y_neu, int b_neu, int h_neu, String s_neu)
  { 
    x = x_neu; y = y_neu; b = b_neu; h = h_neu; s = s_neu;
    losgelassen();
  }
  
  void losgelassen()
  {
    stroke(Randfarbe_d); strokeWeight(3); fill(Buttonfarbe);
    rect(x, y, b, h);
    stroke(Randfarbe_h); strokeCap(ROUND);
    line(x, y, x+b, y); line(x, y, x, y+h);
    font = createFont("CALIBRI", 20); 
    textFont(font); 
    fill(Schriftfarbe);
    textAlign(CENTER, CENTER);
    text(s, x, y+3, b, h);
  }
  
  void gedrueckt()
  {
    stroke(Randfarbe_d); strokeWeight(3); fill(Buttonfarbe);
    rect(x, y, b, h);
    stroke(Randfarbe_h); strokeCap(ROUND);
    line(x, y+h, x+b, y+h); line(x+b, y, x+b, y+h);
    font = createFont("CALIBRI", 20); 
    textFont(font); 
    fill(Schriftfarbe);
    textAlign(CENTER, CENTER);
    text(s, x, y+3, b, h);
  }
  
  boolean angeklickt()
  {
     return ((mouseX > x) && (mouseX < x+b) && 
             (mouseY > y) && (mouseY < y+h));
  } 
}

public class AMPEL
{
    // Instanzvariablen
    private KREIS    rotesLicht;
    private KREIS    gelbesLicht;
    private KREIS    gruenesLicht;
    private SCHALTER roterSchalter;
    private SCHALTER gelberSchalter;
    private SCHALTER gruenerSchalter;
    private ZAEHLER_ZYKLISCH Zustand;

    /**
     * Konstruktor fr Objekte der Klasse AMPEL
     */
    public AMPEL(int xPos)
    {
        // Instanzvariable initialisieren
        rotesLicht      = new KREIS(xPos, 60, 60, rot);
        roterSchalter   = new SCHALTER(rotesLicht);
        gelbesLicht     = new KREIS(xPos, 140, 60, gelb);
        gelberSchalter  = new SCHALTER(gelbesLicht);
        gruenesLicht    = new KREIS(xPos, 220, 60, gruen);
        gruenerSchalter = new SCHALTER(gruenesLicht);
        Zustand         = new ZAEHLER_ZYKLISCH(3);
        Reset();
    }
    
    public void Reset()
    {
       Zustand.Set_Null();
       rot();
    }
    
    public void rot()
    {
        roterSchalter.Einschalten();
        gelberSchalter.Ausschalten();
        gruenerSchalter.Ausschalten();
    }
    
    public void rot_gelb()
    {
        roterSchalter.Einschalten();
        gelberSchalter.Einschalten();
        gruenerSchalter.Ausschalten();
    }

    public void gruen()
    {
        roterSchalter.Ausschalten();
        gelberSchalter.Ausschalten();
        gruenerSchalter.Einschalten();
    }
    
    public void gelb()
    {
        roterSchalter.Ausschalten();
        gelberSchalter.Einschalten();
        gruenerSchalter.Ausschalten();
    }
    
    public void alleEinschalten()
    {
        roterSchalter.Einschalten();
        gelberSchalter.Einschalten();
        gruenerSchalter.Einschalten();
    }
    
    public void alleAusschalten()
    {
        roterSchalter.Ausschalten();
        gelberSchalter.Ausschalten();
        gruenerSchalter.Ausschalten();
    }
    
    public void Schalten()
    {
       Zustand.Zaehlen();
       Anzeigen();
    }
    
    private void Anzeigen()
    {
        if (Zustand.Get_Zaehlerstand() == 0) {rot();};
        if (Zustand.Get_Zaehlerstand() == 1) {rot_gelb();};
        if (Zustand.Get_Zaehlerstand() == 2) {gruen();};
        if (Zustand.Get_Zaehlerstand() == 3) {gelb();};
    } 
}

class KREIS
{
  int x, y, r;
  color f;
  color Randfarbe = #FFFFFF;
  
  KREIS(int x_neu, int y_neu, int r_neu, color f_neu)
  {
    x = x_neu; y = y_neu; r = r_neu; f = f_neu;
  }
  
  void sichtbarMachen()
  {
    stroke(Randfarbe); strokeWeight(2);
    fill(f);
    ellipse(x, y, r, r);
  }
  
  void unsichtbarMachen()
  {
    stroke(Randfarbe); strokeWeight(2);
    fill(Hintergrundfarbe);
    ellipse(x, y, r, r);
  }
}

public class ZAEHLER_ZYKLISCH
{
    int Zaehlerstand;
    int Max;

    public ZAEHLER_ZYKLISCH(int max)
    {
        Zaehlerstand = 0;
        Max = max;
    }

    public void Set_Null()
    {
        Zaehlerstand = 0;
    }
    
    public void Zaehlen()
    {
        if (Zaehlerstand == Max) {Set_Null();} 
                            else {Zaehlerstand = Zaehlerstand +1;};
        
    }
    
    public int Get_Zaehlerstand()
    {
        return Zaehlerstand;
    }        
}

public class SCHALTER      
{    
    private boolean Schalter_ein;   // Instanzvarable fr den Zustand
    private KREIS   Licht;          // Variable zur Visualsierung
    
    /**
     * Konstruktor fr Objekte der Klasse Schalter
     * Ausgangszustand: Der Schalter ist aus
     * @param Objekt der Klasse Kreis, dient zur Visualisierung
     */
    public SCHALTER(KREIS k)
    {
        Schalter_ein = false;       // Startzustand setzen
        Licht = k;                  // Speichern des Objektes zur Visualisierung
        Licht.sichtbarMachen();     // sonst erscheint das leere Fenster nicht
        Licht.unsichtbarMachen();   // gewnschter Anfangszustand
    }
   
    /**
     * Einschalten
     * Der Schalter steht unabhngig vom Zustand danach auf ein
    */
    public void Einschalten()
    {
        Schalter_ein = true;
        Protokoll("Einschalten");
    }
    
    /**
     * Ausschalten
     * Der Schalter steht unabhngig vom Zustand danach auf aus
    */
    public void Ausschalten()
    {
        Schalter_ein = false;
        Protokoll("Ausschalten");
    } 
    
    
    public boolean Get_Schalterstellung()
    {
        return Schalter_ein;
    }
    
    /**
     * Umschalten
     * Der Schalter hat ABHNGIG vom Zustand danach den jeweils anderen Zustand
    */
    public void Umschalten()
    {
        Protokoll("Umschalten");
        if (Get_Schalterstellung()) {Ausschalten();} else {Einschalten();};
    }
    
    private void Protokoll(String gerufen_von)
    {
        if (Get_Schalterstellung()) {Licht.sichtbarMachen();}
                               else {Licht.unsichtbarMachen();};
     }
                            
    
}
